//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
#include "Kolejka.h"

#pragma hdrstop
//---------------------------------------------------------------------------
//   Important note about DLL memory management when your DLL uses the
//   static version of the RunTime Library:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library MEMMGR.LIB to both the DLL project and
//   any other projects that use the DLL.  You will also need to use MEMMGR.LIB
//   if any other projects which use the DLL will be performing new or delete
//   operations on any non-TObject-derived classes which are exported from the
//   DLL. Adding MEMMGR.LIB to your project will change the DLL and its calling
//   EXE's to use the BORLNDMM.DLL as their memory manager.  In these cases,
//   the file BORLNDMM.DLL should be deployed along with your DLL.
//
//   To avoid using BORLNDMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//
//   If your DLL uses the dynamic version of the RTL, you do not need to
//   explicitly add MEMMGR.LIB as this will be done implicitly for you
//---------------------------------------------------------------------------

extern "C" __declspec(dllexport) bool __stdcall ZalozHak(void);
extern "C" __declspec(dllexport) bool __stdcall UsunHak(void);
//dodatkowe
extern "C" __declspec(dllexport) bool __stdcall Initiate(void) {return ZalozHak();};
extern "C" __declspec(dllexport) bool __stdcall Finish(void) {return UsunHak();};

extern "C" __declspec(dllexport) TCyfra __stdcall TrueRandom(void);
extern "C" __declspec(dllexport) unsigned __int64 __stdcall TrueRandomNumbersAmount(void);



HHOOK uchwytHooka=NULL;
HINSTANCE uchwytDLL=NULL;

enum TMiejscePrzechowywania {mpPlik,mpPamiec} miejscePrzechowywania=mpPlik;
Kolejka* kolejka;

#pragma argsused
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fwdreason, LPVOID lpvReserved)
{
	switch(fwdreason)
	{
	    case DLL_PROCESS_ATTACH:
            //MessageBox(NULL,"Biblioteka TrueRandomNumbersGenerator.dll zaadowana do pamici","Inicjacja TrueRandomNumbersGenerator.dll",MB_OK | MB_ICONINFORMATION);
            uchwytDLL=hinstDLL;
            switch(miejscePrzechowywania)
            {
                case mpPlik:
                    char nazwaPliku[MAX_PATH];
                    GetTempPath(MAX_PATH,nazwaPliku); //katalog TEMP=
                    strcat(nazwaPliku,"TrueRandom.txt");
                    //MessageBox(NULL,nazwaPliku,nazwaPliku,MB_OK);
                    kolejka=new KolejkaPlik(nazwaPliku);
                    break;
            }
            break;
        case DLL_PROCESS_DETACH:
            //MessageBox(NULL,"Usuwanie biblioteki TrueRandomNumbersGenerator.dll z pamici","Koczenie TrueRandomNumbersGenerator.dll",MB_OK | MB_ICONINFORMATION);
		    break;
    }

    return 1;
}
//---------------------------------------------------------------------------

bool __stdcall ZalozHak(void)
{
    //deklaracja funkcji obslugujacej hooka zwiazanego z komunikatem o nacisnietym klawiszu
    LRESULT CALLBACK KeyboardProc(
        int code,	// hook code
        WPARAM wParam,	// virtual-key code
        LPARAM lParam 	// keystroke-message information
        );

    //SetWindowHookEx(typ hhoka,adres funkcji obslugujacej,uchwyt biblioteki z funkcja obsl.,id. watku)
    if (uchwytHooka==NULL) uchwytHooka=SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)KeyboardProc,uchwytDLL/*biezaca DLL*/,NULL);
    else return false;
    //if (uchwytHooka==NULL) MessageBox(NULL,"Hook setting failed","TrueRandomNumbersGenerator.dll",MB_OK | MB_ICONERROR);
    return (uchwytHooka!=NULL);
}

bool __stdcall UsunHak(void)
{
    bool wynik=UnhookWindowsHookEx(uchwytHooka);
    //if (!wynik) MessageBox(NULL,"Hook unhooking failed", "TrueRandomNumbersGenerator.dll", MB_OK | MB_ICONERROR);
    return wynik;
}

//---------------------------------------------------------------------------

LRESULT CALLBACK KeyboardProc(
                    int code,	// hook code
                    WPARAM wParam,	// virtual-key code
                    LPARAM lParam 	// keystroke-message information
                    )
{
    //MessageBox(NULL,"Hook!","Inicjacja KeyHook",MB_OK | MB_ICONINFORMATION);
    if (code>=HC_ACTION & ((lParam & 0x80000000)!=0))
    {
        long ticks=GetTickCount();
        TCyfra random=ticks-10*(ticks/10);

        kolejka->WstawNaKoniec(random);
        //if((lParam & 0x80000000)==0) Beep(150,50);
        //else Beep(50,50);
    }
    return CallNextHookEx(uchwytHooka,code,wParam,lParam); //przekazywanie hooka dalej
}

//---------------------------------------------------------------------------

TCyfra __stdcall TrueRandom(void)
{
    return kolejka->ZdejmijZPoczatku();
}

unsigned __int64 __stdcall TrueRandomNumbersAmount(void)
{
    return kolejka->IleZostalo();
}
